package gov.va.genisis2.ts.dto;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SolrDocDTO implements Serializable {

	private static final long serialVersionUID = 2718281828314159265L;

	private String id;
	private String label;
	private String labelWithOntologyName;
	private String definition;
	private Boolean hasMapping;

	/**
	 * @return the id
	 */
	@JsonProperty("conceptUri")
	public String getId() {
		return (null != id) ? id.trim() : null;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	@JsonProperty("id")
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the label
	 */
	@JsonProperty("label")
	public String getLabel() {
		return (null != label) ? label.trim() : null;
	}

	/**
	 * @param label
	 *            the label to set
	 */
	@JsonProperty("Label")
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return the labelWithOntologyName
	 */
	public String getLabelWithOntologyName() {
		return labelWithOntologyName;
	}

	/**
	 * @param labelWithOntologyName
	 *            the labelWithOntologyName to set
	 */
	public void setLabelWithOntologyName(String labelWithOntologyName) {
		this.labelWithOntologyName = labelWithOntologyName;
	}

	/**
	 * @return the definition
	 */
	@JsonProperty("definition")
	public String getDefinition() {
		return (null != definition) ? definition.trim() : null;
	}

	/**
	 * @param definition
	 *            the definition to set
	 */
	@JsonProperty("Definition")
	public void setDefinition(String definition) {
		this.definition = definition;
	}

	/**
	 * @return the hasMapping
	 */
	public Boolean getHasMapping() {
		return hasMapping;
	}

	/**
	 * @param hasMapping the hasMapping to set
	 */
	public void setHasMapping(Boolean hasMapping) {
		this.hasMapping = hasMapping;
	}
}
